/*****************************************************************************
* SPY-PROF.C
******************************************************************************
*
* Template program for building custom Application specific PMSPY profiles
*
* - A table defines the custom GROUPs and MSGs.
*
*   >>>> adjust this with your application's MSGs
*
* - This program processes the table, formats PROfile statements, and writes
*   it to STDOUT
*
* - Just use simple I/O redirection to write to disk file
*
*   example: SPY-PROF >SPY-PROF.PRO
*
* - The disk file can then be specified on the PMSPY command line -or-
*   until the FILE action bar item to allow you to use your application's
*   MSGs
*
*   example: PMSPY /PRO=SPY-PROF.PRO
*            PMSPY /APP=SPY-PROF.PRO
*
* - Build instructions:
*
*   make spy-prof.mak
*
******************************************************************************
* History:
* --------
* 001 - 12/29/89 - steve diering - creation
*
*****************************************************************************/

/*************************************************************************
* Standard C #include's
*************************************************************************/

#include <stdio.h>

/*************************************************************************
* Include your application's #include's here
*
* -- it is needed to provide the binary values of your application MSGs
*
*************************************************************************/

#include "pmspy.h"

/*************************************************************************
* Define output strings used in custom profile
*
* -- adjust these to meet your application's requirements
*
*************************************************************************/

  /*************************************************************************
  * APPlication name - adjust as necessary
  *************************************************************************/

#define APP_NAME   "PMSPY"

  /*************************************************************************
  * stderr messages - these NEVER get re-directed
  *************************************************************************/

#define PGM_TITLE  "Generate PM Spy Profile for " APP_NAME "\n\n"

  /*************************************************************************
  * PROfile data formating strings
  *************************************************************************/

#define PRO_TITLE        "*** PM Spy Profile for " APP_NAME " ***\n"

#define PRO_GROUP        "\nGroup %-32.32s %d\n\n"
#define PRO_MSG          " Define %-30.30s 0x%-4.4X\n"

  /*************************************************************************
  *
  * Note: you can have each GROUP and/or MSG name automatically prefixed
  *       with text so that is 'sorts' to the top of the Group and/or Message
  *       Selection lists.  This is particularly nice becauses it gets YOUR
  *       messages in front of all those WM_* messages!
  *
  *       To enable automatic prefixing, change the following
  *       #undef to a #define then adjust the prefix string value, if desired
  *
  *************************************************************************/

#undef   Want_PREFIX    // <====== change #undef to #define to enable PREFIXes

#if defined(Want_PREFIX)
   #define PRO_PREFIX_GROUP "@"
   #define PRO_PREFIX_MSG   "*"
#else
   #define PRO_PREFIX_GROUP
   #define PRO_PREFIX_MSG
#endif

/*************************************************************************
* Define data structure and macros used to 'define' Custom PROfile data
*************************************************************************/

typedef enum { isGROUP,              // this item starts a new GROUP
               isMSG,                // this item defines a MSG
               isEOL } OPCODE;       // this item end the PROfile data

#define defGROUP(group,color) {isGROUP, PRO_PREFIX_GROUP #group, color }
#define defMSG(msg)           {isMSG  , PRO_PREFIX_MSG   #msg  , msg   }
#define defEOL                {isEOL  , NULL                   , NULL  }

/*************************************************************************
* Define Custom PROfile data
*
* Rules:
* ------
* - the GROUP name must be one contiguous string of letters, etc.
*   NO imbedded blanks are allowed.  use dashes or underscores to
*   "tie together" words into a single GROUP name
*
* - the number specified on the GROUP definition is the COLOR INDEX to be
*   used for all MSGs in this GROUP.  Only 1..8 are valid (no error checking
*   is made!)
*
* - the MSG name must be specified EXACTLY as it is #define in your #include
*   file (since this is how it's binary value is generated!)
*
*************************************************************************/

struct {
         OPCODE   Op;        // defines what this item is (GROUP, MSG, etc)
         char    *Name;      // name of GROUP or MSG
         unsigned Value;     // Color for GROUP, binary MSG value
       } sItems[] =
{
  /*************************************************************************
  * Define GROUP consisting of messages from PMSPYDLL --> PMSPY
  *************************************************************************/

  defGROUP(DLL-to-SPY, 2),

    defMSG(MSG_FROM_SPY_HOOK),

  /*************************************************************************
  * Define GROUP consisting of internal PMSPY messages
  *************************************************************************/

  defGROUP(SPY-to-SPY, 3),

    defMSG(PMSPY_QUIT_NOTICE),

  /*************************************************************************
  * Define End-Of-List marker
  *************************************************************************/

 defEOL
};

/*************************************************************************
* Away we go....
*************************************************************************/

main(argc, argv, envp)
   int argc;
   char *argv[];
   char *envp[];
{

  register unsigned nItems;

  fprintf( stderr, PGM_TITLE);

  printf( PRO_TITLE );

  /*************************************************************************
  * Process the items until the End-Of-List is detected
  *************************************************************************/

  for(nItems = 0;
      sItems[nItems].Op != isEOL;
      nItems++)
  {
    /*************************************************************************
    * Process based on what type of item it is
    *************************************************************************/
    switch( sItems[nItems].Op )
    {
      /***********************************************************************
      * Generate GROUP statement
      ***********************************************************************/
      case isGROUP:
           printf( PRO_GROUP,
                   sItems[nItems].Name,            // GROUP name
                   sItems[nItems].Value );         // GROUP color
      break;

      /***********************************************************************
      * Generate MSG statement
      ***********************************************************************/
      case isMSG:
           printf( PRO_MSG,
                   sItems[nItems].Name,            // MSG   name
                   sItems[nItems].Value );         // MSG   value
      break;
    }
  }
}
